package gov.va.vamf.scheduling.direct.domain

import spock.lang.Specification

class CustomRequestSettingsSpec extends Specification {

    def 'CustomRequestSettings#findCustomRequestSettingById(String) should find a setting by id'() {
        when:
        def settings = makeCustomRequestSettings(3)

        then:
        settings.findCustomRequestSettingById(settings[0].id).orElse(null) == settings[0]
        settings.findCustomRequestSettingById(settings[1].id).orElse(null) == settings[1]
        settings.findCustomRequestSettingById(settings[2].id).orElse(null) == settings[2]
    }

    def 'CustomRequestSettings#findCustomRequestSettingById(String) should return an empty Optional when a setting is not found'() {
        expect:
        !settings.findCustomRequestSettingById('nope').isPresent()

        where:
        settings << [makeCustomRequestSettings(0), makeCustomRequestSettings(3)]
    }

    private def makeCustomRequestSettings(count) {
        (1..count).collect { new CustomRequestSetting("id-$it", '', false, null) } as CustomRequestSettings
    }
}
